<?php

require_once("TField.php");

class TTimeField extends TField
{
    public function SetValue($value)
    {
        if (strpos($value, ':') !== false)
        {
            $this->value['hour'] = (int)substr($value, 0, strpos($value, ':'));
            $value = substr($value, strpos($value, ':') + 1);
        }
        elseif ($value) $this->value['hour'] = (int)$value;
        else $this->value['hour'] = 0;

        if (strpos($value, ':') !== false)
        {
            $this->value['min'] = (int)substr($value, 0, strpos($value, ':'));
            $value = substr($value, strpos($value, ':') + 1);
        }
        elseif ($value) $this->value['min'] = (int)$value;
        else $this->value['min'] = 0;

        if ($value) $this->value['sec'] = (int)$value;
               else $this->value['sec'] = 0;

        $this->displayValue = str_pad($this->value['hour'], 2, '0').':'.str_pad($this->value['min'], 2, '0').':'.str_pad($this->value['sec'], 2, '0');
    }

    public function SetTimeValue($hour, $min, $sec)
    {
        $this->value['hour'] = $hour;
        $this->value['min'] = $min;
        $this->value['sec'] = $sec;
        $this->displayValue = $hour.':'.$min.':'.$sec;
    }

    protected function ShowFieldEditor($formFieldName)
    {
        $timeinfo = $this->GetValue();
        $hour = $timeinfo['hour'];
        $min = $timeinfo['min'];
        $sec = $timeinfo['sec'];
        echo "\n    <div id='field_".$formFieldName."' class='TimeField'>";
        echo "\n    <label for='".$formFieldName."_hour' id='lbl_".$formFieldName."'>".$this->caption.":</label>";
        echo "\n    <input type='text' style='width: 2em' name='".$formFieldName."_hour' id='".$formFieldName."_hour' value='".$hour."'>:";
        echo       "<input type='text' style='width: 2em' name='".$formFieldName."_min' id='".$formFieldName."_min' value='".$min."'>:";
        echo       "<input type='text' style='width: 2em' name='".$formFieldName."_sec' id='".$formFieldName."_sec' value='".$sec."'>";
        echo "\n    </div>";
    }
}

?>