<?php

require_once("TObject.php");
require_once("TField.php");
require_once("TTextField.php");
require_once("TNumberField.php");
require_once("TDateField.php");
require_once("TDateTimeField.php");
require_once("TTimeField.php");
require_once("TFileField.php");
require_once("TPictureField.php");
require_once("TTableField.php");

class TTable extends TObject
{                 private $openWhere;
	/* PRIVATE PROPERTIES */
    private $tableAliasVar;
    private $errorMessage = "";

    /* PUBLIC PROPERTIES */

    public $internalName;
    public $tableName;
    public $caption;
    public $name;
    public $fields = array();
    public $sqlWhere;
    public $sqlOrder;

    public $allowEdit;
    public $allowDelete;
    public $allowAdd;

    /* Table status information */

    private $isActive;
    private $isEof;
    private $isTree;

    /* Data access */

    private $dataSource;
    private $dataConnection;
    private $dataRow;

    /* Constructori si destructori */

    function __construct($intName)
    {
    	TObject::__construct();
        $this->isActive = false;
        $this->isEof = true;
        $this->isTree = false;
        $this->dataSource = false;
        $this->dataRow = false;
        $this->internalName = $intName;

        $this->allowAdd = true;
        $this->allowEdit = true;
        $this->allowDelete = true;
    }

    function __clone()
    {
        foreach ($this->fields as $field)
        {
            $this->fields[$field->fieldName] = clone $field;
            $this->fields[$field->fieldName]->table = $this;
        }
    }

    /* Properties */

    function __get($property)
    {
    	switch ($property)
    	{
    		case "tableAlias":
    			if ($this->tableAliasVar)
    				return $this->tableAliasVar;
    			else
    			    return $this->tableName;
    			break;
            case "recordCount":
                if ($this->isActive)
                    return mysql_num_rows($this->dataSource);
                else
                    return 0;
            case "Active":
                return $this->isActive;
                break;
            case "Eof":
                return $this->isEof;
                break;
    	}
    }

    function __set($property, $propertyValue)
    {
    	switch ($property)
    	{
    		case "tableAlias":
    			$this->tableAliasVar = $propertyValue;
    			break;
    	}
    }

    /* Data manipulation */

    private function GetSourceFilter(TTable $table, $wantedFields, $filtru)
    {
        if (strpos($wantedFields, ';') === false)
        {
            $returnValue = '(`'.$table->tableAlias.'`.`'.$table->fields[$wantedFields]->fieldName.'`'.
                           " LIKE '%$filtru%')";
            return $returnValue;
        }
        else
        {
            $chunks = explode(';', $wantedFields);
            $returnValue = "";
            $i = 0;
            $sourceValueFields = array();
            foreach ($chunks as $chunk)
            {
                if (substr($chunk, 0, 1) == '[')
                {
                    $sourceValueFields[$i]['prefix'] = substr($chunk, 1, strpos($chunk, ']') - 1);
                    $chunk = substr($chunk, strpos($chunk, ']') + 1);
                }
                else $sourceValueFields[$i]['prefix'] = ($i)?' ':'';
                if (strpos($chunk, '[') !== false)
                {
                    $sourceValueFields[$i]['suffix'] = str_replace(']', '', substr($chunk, strpos($chunk, '[') + 1));
                    $chunk = substr($chunk, 0, strpos($chunk, '['));
                }
                else $sourceValueFields[$i]['suffix'] = '';
                $sourceValueFields[$i++]['field'] = $chunk;
            }
            foreach ($sourceValueFields as $sourceValueField)
            {
                if ($returnValue) $returnValue .= ' OR ';
                $returnValue .= '(`'.$table->tableAlias.'`.`'.$table->fields[$sourceValueField['field']]->fieldName.'`'.
                                " LIKE '%$filtru%')";
            }
            if (!$returnValue) $returnValue = '1=0';
            return '('.$returnValue.')';
        }
    }

    private function GetSourceOrder(TTable $table, $wantedFields, $sort)
    {
        if (strpos($wantedFields, ';') === false)
        {
            return '';
        }
        else
        {
            $chunks = explode(';', $wantedFields);
            $returnValue = "";
            $i = 0;
            foreach ($chunks as $chunk)
            {
                if (substr($chunk, 0, 1) == '[')
                {
                    $sourceValueFields[$i]['prefix'] = substr($chunk, 1, strpos($chunk, ']') - 1);
                    $chunk = substr($chunk, strpos($chunk, ']') + 1);
                }
                else $sourceValueFields[$i]['prefix'] = ($i)?' ':'';
                if (strpos($chunk, '[') !== false)
                {
                    $sourceValueFields[$i]['suffix'] = str_replace(']', '', substr($chunk, strpos($chunk, '[') + 1));
                    $chunk = substr($chunk, 0, strpos($chunk, '['));
                }
                else $sourceValueFields[$i]['suffix'] = '';
                $sourceValueFields[$i++]['field'] = $chunk;
            }
            foreach ($sourceValueFields as $sourceValueField)
            {
                if ($returnValue) $returnValue .= ', ';
                $returnValue .= '`'.$table->tableAlias.'`.`'.$table->fields[$sourceValueField['field']]->fieldName."` $sort";
            }
            return $returnValue;
        }
    }

    function Open()
    {
        global $debug, $connection;

        $oldWhere = '';
        $oldOrder = '';

        if ($debug) echo "<br><b>ENTER:</b> TTable::Open()";

        //if (!$this->isActive)
        //{
            // Cod pentru dataProcessor si connector
            $connector = getuserdata('connector', false);

            $oldWhere = $this->sqlWhere;
            if (isset($_REQUEST['dhx_filter']))
                $filtruArr = $_REQUEST['dhx_filter'];
            else
                $filtruArr = array();
            reset($this->fields);
            foreach($filtruArr as $index => $filtru)
            {
                while (!current($this->fields)->visibleInList) next($this->fields);
                if ($filtru)
                {
                    $field = current($this->fields);
                    if (strlen($this->sqlWhere) > 0) $this->sqlWhere .= ' AND ';
                    if ($field->sourceTable)
                        $this->sqlWhere .= $this->GetSourceFilter($field->sourceTable, $field->sourceValueField, $filtru);
                    else
                        $this->sqlWhere .= '(`'.$this->tableAlias.'`.`'.current($this->fields)->fieldName."` LIKE '%$filtru%') ";
                }
                $index++;
                next($this->fields);
            }

            $oldOrder = $this->sqlOrder;
            if (isset($_REQUEST['dhx_sort']))
                $sortArr = $_REQUEST['dhx_sort'];
            else
                $sortArr = array();
            reset($this->fields);
            $indexVechi = 0;
            foreach($sortArr as $index => $sort)
            {
                while (!current($this->fields)->visibleInList) next($this->fields);
                while ($indexVechi < $index)
                {
                    $indexVechi++;
                    next($this->fields);
                    while (!current($this->fields)->visibleInList) next($this->fields);
                }
                if ($sort)
                {
                    if ($sort == 'des') $sort = 'DESC';
                                   else $sort = 'ASC';
                    $field = current($this->fields);
                    if (strlen($this->sqlOrder) > 0) $this->sqlOrder .= ', ';
                    if ($field->sourceTable)
                        $this->sqlOrder .= $this->GetSourceOrder($field->sourceTable, $field->sourceValueField, $sort);
                    else
                        $this->sqlOrder .= '`'.$this->tableAlias.'`.`'.current($this->fields)->fieldName."` $sort";
                }
                $index++;
                next($this->fields);
            }

            // Deschid sursa de date
            $this->openWhere = $this->sqlWhere;
            $this->dataSource = mysql_query($this->GenerateSelectSQL());
            $this->sqlOrder = $oldOrder;
            $this->sqlWhere = $oldWhere;

            if ($this->dataSource === FALSE)
            {
                $this->errorMessage = mysql_error();
                return;
            }
            $this->dataConnection = new GridConnector($connection);
            if ($debug) echo "<br>&nbsp;&nbsp;&nbsp;&nbsp;Rows in table: ".mysql_numrows($this->dataSource);
            $this->isActive = true;
            $this->FetchRow();
        //}

        if ($debug) echo "<br><b>EXIT:</b> TTable::Open()";
    }

    function Close()
    {
        global $debug;
        if ($debug) echo "<br><b>ENTER:</b> TTable::Close()";
    	$this->isActive = false;
    	$this->dataSource = false;
    	$this->dataRow = false;
        if ($debug) echo "<br><b>EXIT:</b> TTable::Close()";
    }

    function ShowSQL()
    {
    	echo "<pre>";
    	echo $this->GenerateSelectSQL();
    	echo "</pre>";
    }

    private function GetRowValues()
    {
        global $debug;
        if ($debug) echo "<br>[ENTER] GetRowValues() ".$this->tableName;
        foreach ($this->fields as $field)
        {
            if ($this->dataRow)
            {
                if (isset($this->dataRow[$field->fieldAlias]))
                {
                    if ($debug) echo "<br> ".$field->fieldAlias." = ".$this->dataRow[$field->fieldAlias];
                    $field->sqlValue = $this->dataRow[$field->fieldAlias];
                }
                else
                {
                    $field->sqlValue = null;
                }
            }
            else
            {
                if ($field->defaultValue != null)
                    $field->value = $field->defaultValue;
                else
                    $field->sqlValue = null;
            }
            if ($field->detailTable)
            {
                $field->detailTable->dataRow = $this->dataRow;
                $field->detailTable->GetRowValues();
            }
            if ($field->sourceTable)
            {
                $field->sourceTable->dataRow = $this->dataRow;
                $field->sourceTable->GetRowValues();
            }
        }
        if ($debug) echo "<br>[EXIT] GetRowValues() ".$this->tableName;
    }

    public function FetchRow()
    {
    	if (!$this->isActive) return false;
    	$this->dataRow = mysql_fetch_assoc($this->dataSource);
    	if ($this->dataRow === FALSE)
        {
            $this->isEof = true;
            $this->GetRowValues(); // Sets the default row values if specified, the rest are NULL
    	    return false; // No more rows
        }
    	else
    	{
            $this->isEof = false;
            $this->GetRowValues();
    		return true;
    	}
    }

    public function AddField($caption, $fieldName, $fieldType, $isPrimaryKey = false, $isAutoGenerated = false, $visibleInList = true, $visibleInForm = true, $nullIfZero = false)
    {
        if ($fieldType == "text")
            $this->fields[$fieldName] = new TTextField();
        elseif ($fieldType == "number")
            $this->fields[$fieldName] = new TNumberField();
        elseif ($fieldType == "date")
            $this->fields[$fieldName] = new TDateField();
        elseif ($fieldType == "datetime")
            $this->fields[$fieldName] = new TDateTimeField();
        elseif ($fieldType == "time")
            $this->fields[$fieldName] = new TTimeField();
        elseif ($fieldType == "file")
            $this->fields[$fieldName] = new TFileField();
        elseif ($fieldType == "picture")
            $this->fields[$fieldName] = new TPictureField();
        else
            $this->fields[$fieldName] = new TField();
        $this->fields[$fieldName]->table = $this;
        $this->fields[$fieldName]->caption = $caption;
        $this->fields[$fieldName]->fieldName = $fieldName;
        $this->fields[$fieldName]->fieldType = $fieldType;
        $this->fields[$fieldName]->isPrimaryKey = $isPrimaryKey;
        $this->fields[$fieldName]->isAutoGenerated = $isAutoGenerated;
        $this->fields[$fieldName]->visibleInList = $visibleInList;
        $this->fields[$fieldName]->visibleInForm = $visibleInForm;
        $this->fields[$fieldName]->sourceTable = null;
        $this->fields[$fieldName]->sourceSQL = null;
        $this->fields[$fieldName]->sourceKeyField = null;
        $this->fields[$fieldName]->sourceValueField = null;
        $this->fields[$fieldName]->sourceDisplayMode = "select";
        $this->fields[$fieldName]->NULLifZero = $nullIfZero;
        $this->fields[$fieldName]->allowNULL = true;
        return $this->fields[$fieldName];
    }

    public function AddRequiredField($caption, $fieldName, $fieldType, $isPrimaryKey = false, $isAutoGenerated = false, $visibleInList = true, $visibleInForm = true, $nullIfZero = false)
    {
        $this->AddField($caption, $fieldName, $fieldType, $isPrimaryKey, $isAutoGenerated, $visibleInList, $visibleInForm, $nullIfZero);
        $this->fields[$fieldName]->allowNULL = false;
        return $this->fields[$fieldName];
    }

    public function AddForeignField($caption, $fieldName, $fieldType, TTable $sourceTable, $sourceKeyField, $sourceValueFields, $displayMode = "select", $allowNULL = false, $allowAddNew = true, $visibleInList = true, $visibleInForm = true)
    {
    	$field = $this->AddField($caption, $fieldName, $fieldType, false, false, $visibleInList, $visibleInForm, true);
    	$field->sourceTable = clone $sourceTable;
    	$field->sourceKeyField = $field->sourceTable->fields[$sourceKeyField];
    	$field->sourceValueField = $sourceValueFields;
    	$field->sourceDisplayMode = $displayMode;
    	$field->allowNULL = $allowNULL;
    	$field->sourceAllowAddNew = $allowAddNew;
        $field->gridType = "ro";
        return $this->fields[$fieldName];
    }

    public function AddFieldForeignSource($fieldName, TTable $sourceTable, $sourceKeyField, $sourceValueField, $displayMode = "select", $allowNULL = false, $allowAddNew = false)
    {
        $this->fields[$fieldName]->sourceTable = clone $sourceTable;
        $this->fields[$fieldName]->sourceKeyField = $sourceKeyField;
        $this->fields[$fieldName]->sourceValueField = $sourceValueField;
        $this->fields[$fieldName]->sourceDisplayMode = $displayMode;
        $this->fields[$fieldName]->allowNULL = $allowNULL;
        $this->fields[$fieldName]->sourceAllowAddNew = $allowAddNew;
        $this->fields[$fieldName]->sourceSQL = null;
        $this->GenerateSelectSQL();
    }

    public function AddFieldForeignSQLSource($fieldName, $sourceSQL, $sourceKeyField, $sourceValueField, $displayMode = "select", $allowNULL = false)
    {
        $this->fields[$fieldName]->sourceSQL = clone $sourceSQL;
        $this->fields[$fieldName]->sourceKeyField = $sourceKeyField;
        $this->fields[$fieldName]->sourceValueField = $sourceValueField;
        $this->fields[$fieldName]->sourceDisplayMode = $displayMode;
        $this->fields[$fieldName]->allowNULL = $allowNULL;
        $this->fields[$fieldName]->sourceTable = null;
        $this->GenerateSelectSQL();
    }

    public function AddFieldChild($fieldName, TTable $childTable, $childKeyField)
    {
        $index = count($this->fields[$fieldName]->children);
        $this->fields[$fieldName]->children[$index]['table'] = clone $childTable;
        $this->fields[$fieldName]->children[$index]['key_field'] = $childKeyField;
        $childTable->AddParentField($childKeyField, $this->fields[$fieldName]);
        $this->GenerateSelectSQL();
    }

    public function AddDetailField($caption, $fieldName, $fieldType, TTable $detailTable, $detailKeyField, $detailValueField, $visibleInList = true, $visibleInForm = true)
    {
        $field = $this->AddField($caption, $fieldName, $fieldType, false, false, $visibleInList, $visibleInForm, true);
        $field->detailTable = clone $detailTable;
        $field->detailKeyField = $field->detailTable->fields[$detailKeyField];
        $field->detailValueField = $detailValueField;
        $field->gridType = "ro";
    }

    public function AddFieldDetail($fieldName, TTable $detailTable, $detailKeyField, $detailValueField)
    {
        $this->fields[$fieldName]->detailTable = $detailTable;
        $this->fields[$fieldName]->detailKeyField = $detailKeyField;
        $this->fields[$fieldName]->detailValueField = $detailValueField;
        $this->GenerateSelectSQL();
    }

    public function AddParentField($fieldName, TField $parent)
    {
        $this->fields[$fieldName]->parentField = $parent;
        $index = count($parent->children);
        $parent->children[$index]['table'] = $this;
        $parent->children[$index]['key_field'] = $this->fields[$fieldName];
        $this->fields[$fieldName]->visibleInForm = false;
        $this->GenerateSelectSQL();
    }

    public function SetValue($fieldName, $value)
    {
        $this->fields[$fieldName]->SetValue($value);
    }

    public function GetValue($fieldName)
    {
        return $this->fields[$fieldName]->GetValue();
    }

    public function GetUserValues()
    {
        foreach ($this->fields as $field)
        {
            $formFieldName = $field->table->tableName.'_'.$field->fieldName;
            if (get_class($field) == 'TTimeField')
            {
                $field->SetTimeValue(getuserdata($formFieldName.'_hour'), getuserdata($formFieldName.'_min'), getuserdata($formFieldName.'_sec'));
            }
            elseif (get_class($field) == 'TPictureField')
            {
                if (isset($_FILES[$formFieldName.'_image']))
                {
                    if ($_FILES[$formFieldName.'_image']['error'] == UPLOAD_ERR_OK)
                        $field->SetPictureValue(getuserdata($formFieldName.'_id'),
                                                getuserdata($formFieldName.'_path'),
                                                getuserdata($formFieldName.'_type'),
                                                getuserdata($formFieldName.'_title'),
                                                $_FILES[$formFieldName.'_image']['name'],
                                                $_FILES[$formFieldName.'_image']['tmp_name'],
                                                $_FILES[$formFieldName.'_image']['type']);
                    else
                        $field->SetPictureValue(getuserdata($formFieldName.'_id'),
                                                getuserdata($formFieldName.'_path'),
                                                getuserdata($formFieldName.'_type'),
                                                getuserdata($formFieldName.'_title'),
                                                '', '', '');
                }
                else
                    $field->SetPictureValue(getuserdata($formFieldName.'_id'),
                                            getuserdata($formFieldName.'_path'),
                                            getuserdata($formFieldName.'_type'),
                                            getuserdata($formFieldName.'_title'),
                                            '', '', '');
            }
            else
            {
                $field->SetValue(getuserdata($formFieldName));
            }
            if ($field->detailTable)
            {
                $field->detailTable->GetUserValues();
            }
        }
    }

    /* GENERARE SQL */

    private function GetSQLSelectFields(array &$joins, &$aliasIndex, $linkField, $joinTable, $joinField)
    {
        // Add table to join list, if $linkField exists
        if ($linkField)
        {
            $found = false;
            foreach ($joins as $join)
                if ($join['table'] == '`'.$this->tableName.'`')
                {
                    $found = true;
                    break;
                }
            if (!$found)
            {
                $this->tableAlias = $this->tableName;
            }
            else
            {
                $aliasIndex++;
                $this->tableAlias = 'T'.$aliasIndex;
            }
            $index = count($joins);
            $joins[$index]['table'] = '`'.$this->tableName.'`';
            $joins[$index]['alias'] = $this->tableAlias;
            $joins[$index]['field'] = $linkField;
            $joins[$index]['join_table'] = $joinTable;
            $joins[$index]['join_field'] = $joinField;
        }

    	$sqlfields = "";
    	foreach ($this->fields as $field)
    	{
            if ( ($field->sourceTable) && ($field->sourceGetAllFields) )
            {
                $sqlfields .= (($sqlfields)?",\n    ":"\n    ").
                    $field->sourceTable->GetSQLSelectFields($joins, $aliasIndex, $field->sourceKeyField->fieldName, $this->tableAlias, $field->fieldName);
            }
            elseif ( ($field->detailTable) && (false) )
            {
                $sqlfields .= (($sqlfields)?",\n    ":"\n    ").
                    $field->detailTable->GetSQLSelectFields($joins, $aliasIndex, $field->detailKeyField->fieldName, $this->tableAlias, $field->fieldName);
            }
            elseif ($field->treeParentField)
            {

                $sqlfields .= (($sqlfields)?",\n    ":"\n    ").
                              'IFNULL(`'.(($this->tableAlias)?$this->tableAlias:$this->tableName).'__CHILDREN__`.`'.
                              $field->fieldName.'__CHILDCOUNT__`, 0) AS `'.$field->fieldAlias.'__CHILDCOUNT__`';
                $index = count($joins);
                $joins[$index]['table'] = "(SELECT `".$field->fieldName."`, COUNT(1) AS `".
                    $field->fieldName."__CHILDCOUNT__` FROM `".$field->table->tableName."` ".
                    "GROUP BY `".$field->fieldName."`)";
                $joins[$index]['alias'] = (($this->tableAlias)?$this->tableAlias:$this->tableName)."__CHILDREN__";
                $joins[$index]['field'] = $field->fieldName;
                $joins[$index]['join_table'] = $this->tableAlias;
                $joins[$index]['join_field'] = $this->fields[$field->treeParentField]->fieldName;
            }
            else
            {
    		    $sqlfields .= (($sqlfields)?",\n    ":"\n    ").
    		                  '`'.(($this->tableAlias)?$this->tableAlias:$this->tableName).'`.`'.
    		                  $field->fieldName.'` AS `'.$field->fieldAlias.'`';
            }
    	}
    	return $sqlfields;
    }

    private function GenerateSelectSQL()
    {
        global $debug;
        if ($debug) echo "<br><b>ENTER:</b> TTable::GenerateSelectSQL()";
    	// Generate table aliases for all tables
    	/*
        $aliasIndex = 0;
    	$used_tables = array($this->tableName);
    	foreach ($this->fields as $field)
    	{
            $alias = "";
    		if ($field->sourceTable)
    		{
    			if (in_array($field->sourceTable->tableName, $used_tables))
    			{
    				$aliasIndex++;
    				$alias = 'T'.$aliasIndex;
    			}
    			else
    				$alias = $field->sourceTable->tableName;
    			$field->sourceTable->tableAlias = $alias;
    		}
            if ($field->detailTable)
            {
                if (in_array($field->detailTable->tableName, $used_tables))
                {
                    $aliasIndex++;
                    $alias = 'T'.$aliasIndex;
                }
                else
                    $alias = $field->detailTable->tableName;
                $field->detailTable->tableAlias = $alias;
            }
            if ($alias) $used_tables[] = $alias;
    	}
    	*/
        // Generate query
        global $debug;
        $joins = array();
        $joins[0]['table'] = '`'.$this->tableName.'`';
        $joins[0]['alias'] = $this->tableAlias;
        $aliasIndex = 0;
        $sqlSelect = "SELECT ".$this->GetSQLSelectFields($joins, $aliasIndex, '', '', '');
        $sqlJoin = "";
        $primaryKey = "";
        $indexSQL = 0;
        $used_tables = array($this->tableName);
        foreach ($this->fields as $field)
        {
            if ($field->sourceTable)
            {
            	$sqlSelect .= ",\n    ".$field->sourceTable->GetSQLSelectFields($joins, $aliasIndex,
                    $field->sourceKeyField->fieldName, $field->table->tableAlias, $field->fieldName);
            }
            elseif ($field->detailTable)
            {
                $sqlSelect .= ",\n    ".$field->detailTable->GetSQLSelectFields($joins, $aliasIndex,
                    $field->detailKeyField->fieldName, $field->table->tableAlias, $field->fieldName);
            }
        }
        foreach ($joins as $join)
            if ($join['alias'] != $this->tableAlias)
                $sqlJoin .= "\n    LEFT JOIN ".$join['table']." AS `".$join['alias']."` ON `".
                            $join['alias']."`.`".$join['field'].'` = `'.$join['join_table'].'`.`'.$join['join_field']."`";

        $sql = $sqlSelect;
        $gridObj = getuserdata('gridObj');
        $primaryKeys = ""; // string prin care se trimit parametri pt functia de editare
        foreach ($this->fields as $field)
        {
            if ($field->isPrimaryKey)
            {
                $primaryKeys .= (($primaryKeys)?' AND ':'')."`".$field->table->tableAlias."`.`".
                                $field->fieldName.'` = '.$field->value;
            }
        }
        $sql .= "\nFROM `".$this->tableName."`";
        if ($sqlJoin) $sql .= $sqlJoin;
        if ($this->sqlWhere) $sql .= "\nWHERE ".$this->sqlWhere;
        if ($this->sqlOrder) $sql .= "\nORDER BY ".$this->sqlOrder;
        if ($debug) echo "<pre>".$sql."</pre>";
        if ($debug) echo "<br><b>EXIT:</b> TTable::GenerateSelectSQL()";
        return $sql;
    }

    public function GetDatabaseValues($keyValue)
    {
        global $debug;
        $primaryKey = "";
        foreach ($this->fields as $field)
            if ($field->isPrimaryKey) $primaryKey = $field->fieldName;
        $sql = $this->GenerateSelectSQL();
        if ($primaryKey)
            if (strstr($sql, "WHERE")) $sql .= " \nAND `".$this->tableName."`.`".$primaryKey."` = ".(($keyValue)?$keyValue:0);
                                  else $sql .= " \nWHERE `".$this->tableName."`.`".$primaryKey."` = ".(($keyValue)?$keyValue:0);
        $q = mysql_query($sql);
        if ($debug) echo "<pre>".$sql."</pre>";
        if ($r = mysql_fetch_assoc($q))
        {
            foreach ($this->fields as $field)
            {
                $field->SetValue($r[$field->fieldName]);
                if ($field->detailTable)
                    $field->detailTable->GetDatabaseValues($field->GetValue());
            }
        }
    }

    public function ShowList($detail = "", $return_params = array(), $simple = false, $formId = "", $where = "")
    {
        global $page, $debug, $scriptroot, $imagesroot;

        echo "\n<div class='dhtml_content'>";

        $divId = 'grid'.date('YmdHis').rand();
        $gridVar = 'dbg'.date('YmdHis').rand();
        $addFormVar = 'frm'.date('YmdHis').rand();
        $height = $this->recordCount * 25 + 30;
        if ($height < 100) $height = 100;
        if ($height > 250) $height = 280;
        $height = 400;
        echo "<div id='$divId' style='width:580px;height:auto;margin:0px;padding:0px'></div>";
        echo "<script type='text/javascript'>";
        echo "$gridVar = new dhtmlXGridObject('$divId');";
        echo "$gridVar.setImagePath(\"{$scriptroot}js/dhtmlx/imgs/\");";
        //echo "$gridVar.load(\"{$scriptroot}xml/getGrid.php?table=".$this->internalName."&gridObj=$gridVar&where=$where\");";
        echo "$gridVar.setHeader('".$this->GetGridHeaders()."');";
        echo "$gridVar.setInitWidths('".$this->GetGridWidths()."');";
        echo "$gridVar.setColTypes('".$this->GetGridColumnTypes()."');";
        echo "$gridVar.setColumnColor('".$this->GetGridColumnColors()."');";
        echo "$gridVar.setColAlign('".$this->GetGridAlign()."');";
        echo "$gridVar.setColSorting('".$this->GetGridSorting()."');";
        echo "$gridVar.attachHeader('".$this->GetGridFilters()."');";
        echo "$gridVar.setSkin('dhx_skyblue');";
        echo "$gridVar.enableAutoHeight(true,$height,false);";
        echo "$gridVar.enableAutoWidth(true,300,false);";
        echo "$gridVar.setDateFormat('%d.%m.%Y');";
        echo "$gridVar.init();";
        echo "$gridVar.enableSmartRendering(true);";
        //echo "$gridVar.load(\"{$scriptroot}xml/getConnectorGrid.php?table=".$this->internalName."&where=$where\");";
        echo "$gridVar.kidsXmlFile = \"{$scriptroot}xml/getGrid.php?table=".$this->internalName."&gridObj=$gridVar&where=$where\";";
        echo "$gridVar.load(\"{$scriptroot}xml/getGrid.php?table=".$this->internalName."&gridObj=$gridVar&where=$where\");";

        //echo "var {$gridVar}dp = new dataProcessor(\"{$scriptroot}xml/getConnectorGrid.php?table=".$this->internalName."&where=$where\");";
        echo "var {$gridVar}dp = new dataProcessor(\"{$scriptroot}xml/getGrid.php?table=".$this->internalName."&gridObj=$gridVar&where=$where\");";
        echo "{$gridVar}dp.init($gridVar);";
        echo "{$gridVar}dp.setTransactionMode('POST');";
        echo "</script>";

        // Butonul de adaugare
        $primaryKeys = ""; // string prin care se trimit parametri pt functia de editare
        $parentFields = "";
        $parentFieldsForChildren = "";
        $isTree = false;
        $treeCellIndex = -1;
        $i = 0;
        foreach ($this->fields as $field)
        {
            if ($field->isPrimaryKey)
            {
                echo "\n    <input type='hidden' name='".$field->fieldName."' value='0'>";
                $primaryKeys .= (($primaryKeys)?' AND ':'')."`".$field->table->tableAlias."`.`".
                                $field->fieldName.'` IS NULL';
            }
            if ($field->parentField != null)
            {
                $parentFields .= $field->parentField->table->tableName.'.'.
                                 $field->parentField->fieldName.'='.
                                 $field->parentField->value;
            }
            if ($field->treeParentField)
            {
                $isTree = true;
                $parentFieldsForChildren .= $this->tableName.'.'.$field->fieldName.'=';
            }
            if ($field->gridType == 'tree') $treeCellIndex = $i;
            if ($field->visibleInList) $i++;
        }
        if (!$isTree)
            echo "\n    <div id='$addFormVar' style='background-color: #EFEFEF; padding: 0; margin: 0'></div>
                  \n    <script type='text/javascript'>
                  \n        var {$addFormVar}Data = [
                  \n            {type:'button', name:'{$addFormVar}_btnAdd', value:'".lang('btnAdd')."'}
                  \n        ];
                  \n        var {$addFormVar}Obj = new dhtmlXForm('$addFormVar', {$addFormVar}Data);
                  \n        {$addFormVar}Obj.attachEvent('onButtonClick', function(name, command) {
                  \n            editDBItem(\"".$this->internalName."\",  \"$primaryKeys\", \"$parentFields\", \"$gridVar\",
                  \n                       \"{$where}\");
                  \n        });
                  \n    </script>";
        else
        {
            echo "\n    <div id='{$addFormVar}root' style='background-color: #EFEFEF;padding:0;margin:0;width:200px;float:left;clear:left'></div>
                  \n    <div id='{$addFormVar}sub' style='background-color: #EFEFEF;padding:0;margin:0;width:200px;float:left;clear:right'></div>
                  \n    <script type='text/javascript'>
                  \n        var {$addFormVar}rootData = [
                  \n            {type:'button', name:'{$addFormVar}_btnAdd', value:'".lang('btnAddRootItem')."'}
                  \n        ];
                  \n        var {$addFormVar}subData = [
                  \n            {type:'button', name:'{$addFormVar}_btnAddSubItem', value:'".lang('btnAddSubItem')."'}
                  \n        ];
                  \n        var {$addFormVar}rootObj = new dhtmlXForm('{$addFormVar}root', {$addFormVar}rootData);
                  \n        var {$addFormVar}subObj = new dhtmlXForm('{$addFormVar}sub', {$addFormVar}subData);
                  \n        {$addFormVar}rootObj.attachEvent('onButtonClick', function(name, command) {
                  \n            editDBItem(\"".$this->internalName."\",  \"$primaryKeys\", \"$parentFields\", \"$gridVar\",
                  \n                       \"{$where}\");
                  \n        });
                  \n        {$addFormVar}subObj.attachEvent('onButtonClick', function(name, command) {
                  \n            var value = $gridVar.getSelectedRowId();
                  \n            if (value != null)
                  \n            {
                  \n                value = value.substr(value.indexOf('__', 0) + 2)
                  \n                value = '$parentFieldsForChildren' + value.substr(value.indexOf('__', 0) + 2);
                  \n                if ('$parentFields' != '') value = value + ';' + '$parentFields';
                  \n                editDBItem(\"".$this->internalName."\",  \"$primaryKeys\", value, \"$gridVar\", \"{$where}\");
                  \n            }
                  \n            else
                  \n            {
                  \n                alert('You must select the row to add subitems to!');
                  \n            }
                  \n        });
                  \n    </script>";
        }

        echo "</div>"; // dhtml_content
    }

    public function ShowEditForm($formId, $includeFormTag = true, $detail = "", $gridId = "", $srcWhere = "",
        $comboId = "", $comboKeyField = "", $comboValueField = "")
    {
        global $page, $action, $scriptroot;
        $return_params = array();

        echo "\n<div class='scrollable_area' style='width: 100%; height: 100%; overflow: auto; background-color: #EFEFEF'>";
        echo "\n<div class='dhtml_content'>";

        $editFormVar = 'frme'.date('YmdHis');

        if ($includeFormTag)
        {
            echo "\n<form method='POST' action='{$_SERVER['PHP_SELF']}' class='generic_form' name='frm_".$this->tableName."' id='frm_".$this->tableName."' enctype='multipart/form-data' target='ajax_target'>";
        }

        echo "\n    <input type='hidden' name='page' id='page' value='$page'>";
        if (!$detail)
        {
            echo "\n    <input type='hidden' name='action' id='action' value='do_edit$detail'>";
            echo "\n    <input type='hidden' name='table' value='".$this->internalName."'>";
            echo "\n    <input type='hidden' name='where' value='".$this->sqlWhere."'>";
        }
        foreach ($this->fields as $field)
        {
            $formFieldName = $field->table->tableName.'_'.$field->fieldName;

            if ($field->visibleInForm)
            {
                $field->ShowEditor();
            }
            else
            {
                echo "\n    <input type='hidden' name='".$formFieldName."' id='".$formFieldName."' value='".$field->formValue."'>";
            }
            if ( ($field->isPrimaryKey) && ($field->formValue) )
            {
                $return_params[$field->table->tableName."_".$field->fieldName] = $field->formValue;
            }
            if ( ($field->parentField) && ($includeFormTag) )
            {
                $formFieldName = $field->parentField->table->tableName.'_'.$field->parentField->fieldName;
                echo "\n    <input type='hidden' name='".$formFieldName."' id='".$formFieldName."' value='".$field->formValue."'>";
            }
        }
        if ($includeFormTag)
        {
            echo "\n</form>";
            echo "\n    <div class='clearAll'>&nbsp;</div>";
            echo "\n    <div id='{$editFormVar}2' style='background-color: #EFEFEF; padding: 0; margin: 0: clear: right; width: 150px; float: right'></div>";
            echo "\n    <div id='{$editFormVar}1' style='background-color: #EFEFEF; padding: 0; margin: 0: clear: left; width: 150px; float: right'></div>";
            echo "\n    <script type='text/javascript'>
                        var {$editFormVar}1Data = [
                                {type:'button', name:'{$editFormVar}_btnSave', value:'".lang('btnSave')."'}
                            ];
                        var {$editFormVar}2Data = [
                                {type:'button', name:'{$editFormVar}_btnCancel', value:'".lang('btnCancel')."'}
                            ];
                        var {$editFormVar}Obj1 = new dhtmlXForm('{$editFormVar}1', {$editFormVar}1Data);
                        var {$editFormVar}Obj2 = new dhtmlXForm('{$editFormVar}2', {$editFormVar}2Data);
                        {$editFormVar}Obj1.attachEvent('onButtonClick', function(btnName) {
                                if (btnName == '{$editFormVar}_btnSave')
                                {
                                    document.frm_".$this->tableName.".submit();
                                    $formId.close();".
                                    (($gridId)?"$gridId.clearAndLoad(\"{$scriptroot}xml/getGrid.php?table=".$this->internalName."&gridObj=$gridId&where=$srcWhere\");":'').
                                    (($comboId)?
                                        "$comboId.clearAll(true);
                                        $comboId.loadXML(\"{$scriptroot}xml/getCombo.php?table=".$this->internalName."&comboObj=$comboId&keyField=$comboKeyField&valueField=$comboValueField\");":'').
                            "   }
                            });
                        {$editFormVar}Obj2.attachEvent('onButtonClick', function(btnName) {
                                if (btnName == '{$editFormVar}_btnCancel')
                                {
                                    $formId.close();
                                }
                            });
            ";
            echo "\n    </script>";
        }
        echo "<div class='clearAll'>&nbsp;</div>";
        echo "</div>"; // dhtml_content
        if ($return_params)
        {
            foreach ($this->fields as $field)
            {
                if (is_array($field->children))
                    foreach ($field->children as $child)
                    {
                        echo "<b>".$child['table']->name.'</b><br>';
                        $child['table']->ShowList(''/*"_".$field->childTable->tableName*/, $return_params, false, $formId,
                            $child['table']->tableAlias.'.'.$child['key_field']->fieldName.'='.$field->formValue);

                    }
            }
        }
        if ($formId) echo "\n<img src='img/spacer.gif' onload='$formId.setText(\"".lang('mscEdit')." ".$this->name."\");'>";
        echo "</div>";
    }

    public function ShowDeleteForm($formId, $includeFormTag = true, $detail = "", $gridId = "", $srcWhere = "")
    {
        global $page, $action, $scriptroot;
        $return_params = array();

        echo "\n<div class='scrollable_area' style='width: 100%; height: 100%; overflow: hidden'>";
        echo "\n<div class='dhtml_content'>";

        $deleteFormVar = 'frmd'.date('YmdHis');

        if ($includeFormTag)
        {
            echo "\n<form method='POST' action='{$_SERVER['PHP_SELF']}' class='generic_form' name='frm_".$this->tableName."' id='frm_".$this->tableName."' enctype='multipart/form-data' target='ajax_target'>";
        }
        echo "\n    <div class='question'>".lang('cnfRecDelete')."</div>";
        echo "\n    <input type='hidden' name='page' id='page' value='$page'>";
        if (!$detail)
        {
            echo "\n    <input type='hidden' name='action' id='action' value='do_delete$detail'>";
            echo "\n    <input type='hidden' name='table' value='".$this->internalName."'>";
            echo "\n    <input type='hidden' name='where' value='".$this->sqlWhere."'>";
        }
        foreach ($this->fields as $field)
        {
            $formFieldName = $field->table->tableName.'_'.$field->fieldName;

            if (!$field->visibleInForm)
            {
                echo "\n    <input type='hidden' name='".$formFieldName."' id='".$formFieldName."' value='".$field->formValue."'>";
            }
            if ( ($field->isPrimaryKey) && ($field->formValue) )
            {
                $return_params[$field->table->tableName."_".$field->fieldName] = $field->formValue;
            }
            if ( ($field->parentField) && ($includeFormTag) )
            {
                $formFieldName = $field->parentField->table->tableName.'_'.$field->parentField->fieldName;
                echo "\n    <input type='hidden' name='".$formFieldName."' id='".$formFieldName."' value='".$field->formValue."'>";
            }
        }
        if ($includeFormTag)
        {
            echo "\n</form>";
            echo "\n    <div id='{$deleteFormVar}No' style='background-color: #EFEFEF;padding:0;margin:0;clear:right;float:right;width:160px'></div>";
            echo "\n    <div id='{$deleteFormVar}Yes' style='background-color: #EFEFEF;padding:0;margin:0;clear:left;float:right;width:140px'></div>";
            echo "\n    <script type='text/javascript'>
                        var {$deleteFormVar}YesData = [
                                {type:'button', name:'{$deleteFormVar}_btnDelete', value:'".lang('btnDelete')."'}
                            ];
                        var {$deleteFormVar}NoData = [
                                {type:'button', name:'{$deleteFormVar}_btnCancel', value:'".lang('btnCancel')."'}
                            ];
                        {$deleteFormVar}YesObj = new dhtmlXForm('{$deleteFormVar}Yes', {$deleteFormVar}YesData);
                        {$deleteFormVar}NoObj = new dhtmlXForm('{$deleteFormVar}No', {$deleteFormVar}NoData);
                        {$deleteFormVar}YesObj.attachEvent('onButtonClick', function(btnName) {
                            document.frm_".$this->tableName.".submit();
                            $formId.close();".
                            (($gridId)?"$gridId.clearAndLoad(\"{$scriptroot}xml/getGrid.php?table=".$this->internalName."&gridObj=$gridId&where=$srcWhere\");":'').
                       "});
                        {$deleteFormVar}NoObj.attachEvent('onButtonClick', function(btnName) {
                            $formId.close();
                        });
                  \n    </script>";
        }
        echo "<div class='clearAll'>";
        echo "</div>"; // dhtml_content
        echo "</div>";
        if ($formId) echo "\n<img src='img/spacer.gif' onload='$formId.setText(\"".lang('mscEdit')." ".$this->name."\");'>";
    }

    public function ProcessGrid()
    {
        global $action;

        $newFields = array();
        $index = 0;
        reset($this->fields);
        while ( (isset($_REQUEST["c$index"])) && (current($this->fields)) )
        {
            while ( (current($this->fields)) && (!current($this->fields)->visibleInList) )
                next($this->fields);
            if (current($this->fields))
                if ((current($this->fields)->sourceTable == null) && (current($this->fields)->detailTable == null))
                {
                    $newFields[$index]['field'] = current($this->fields)->fieldName;
                    $newFields[$index]['value'] = getuserdata("c$index");
                    $newFields[$index]['primary'] = current($this->fields)->isPrimaryKey;
                }
            $index++;
            next($this->fields);
        }

        $sSQL = '';

        switch ($action)
        {
            case 'updated':
                $sSQL = "UPDATE ".$this->tableName." SET ";
                $sWhere = '';
                foreach ($newFields as $newField)
                {
                    if ($newField['primary'])
                        $sWhere .= (($sWhere)?' AND ':'').$newField['field']." = '".$newField['value']."'";
                    else
                    {
                        $this->fields[$newField['field']]->value = $newField['value'];
                        $sSQL .= $newField['field']." = ".$this->fields[$newField['field']]->sqlValue.", ";
                    }
                }
                $sSQL = substr($sSQL, 0, strlen($sSQL) - 2); // scot ultima virgula si spatiul
                $gridId = getuserdata('gr_id');
                if (strpos($gridId, $this->tableName) >= 0)
                {
                    $id = substr($gridId, strlen($this->tableName) + 2);
                    $keyField = substr($id, 0, strpos($id, '__'));
                    $keyValue = substr($id, strpos($id, '__') + 2);
                    $sWhere .= (($sWhere)?' AND ':'').$keyField." = '".$keyValue."'";
                }
                if ($sWhere) $sSQL .= ' WHERE '.$sWhere;
                break;
            case 'inserted':
                break;
            case 'deleted':
                break;
        }
//        echo "<data><action type=\"$action\" sid=\"$gridId\" tid=\"$gridId\" /></data>"; exit;
        if ($sSQL) mysql_query($sSQL);
        if (!mysql_error())
            echo "<data><action type=\"$action\" sid=\"$gridId\" tid=\"$gridId\" /></data>";
        else
            echo "<data><action type=\"$action\" sid=\"$sSQL\" tid=\"0\" /></data>";
    }

    public function Process()
    {
        global $page, $action, $submit, $debug, $imagespath, $imagesroot;
        if ($action == 'do_edit')//$submit == lang('btnSave'))
        {
            foreach ($this->fields as $field)
            {
                if ($field->detailTable)
                {
                    $error = $field->detailTable->Process();
                    if ($error) return $error;
                    //$field->SetValue($field->detailTable->fields[$field->detailKeyField]->GetValue());
                }
            }
            echo $this->internalName;
            $insertSQL = "INSERT INTO `".$this->tableName."` (";
            $insertSQLValues = " VALUES (";
            $updateSQL = "UPDATE `".$this->tableName."` SET ";
            $updateSQLCondition = "";
            $firstField = true;

            foreach ($this->fields as $field)
            {
                $field->formValue = 0; // doesn't matter, value is taken from $_POST
                if ($field->isPrimaryKey)
                {
                    if (!$updateSQLCondition) $updateSQLCondition = " WHERE ";
                                         else $updateSQLCondition .= " AND ";
                    $updateSQLCondition .= "`".$this->tableName."`.`".$field->fieldName."` ";
                    if ($field->formValue != "")
                    {
                        if ( ($field->NULLifZero) && (!$field->formValue) )
                        {
                            $updateSQLCondition .= " IS NULL";
                        }
                        else
                            switch ($field->fieldType)
                            {
                                case "picture":
                                    $value = $field->GetValue();
                                    $picture_id = $value['id'];
                                    $picture_path = $value['image'];
                                    $picture_type = $value['type'];
                                    $picture_title = $value['title'];
                                    $picture_new_name = $value['new_image'];
                                    $picture_new_path = $imagespath;
                                    $picture_new_temp_path = $value['new_image_temp'];
                                    $picture_new_type = $value['new_image_type'];
                                    if ($picture_new_temp_path)
                                    {
                                        if ($picture_path)
                                        {
                                            unlink($imagespath.$picture_path);
                                            if (file_exists($imagespath.$picture_path))
                                                return lang('errCannotDeleteOldImage');
                                        }
                                        $temp_name = $picture_new_name;
                                        $i = 0;
                                        while (file_exists($imagespath.$temp_name))
                                            $temp_name = substr($picture_new_name, 0, strrpos($picture_new_name, '.') - 1).(++$i).
                                                         substr($picture_new_name, strpos($picture_new_name, '.'));
                                        $picture_new_name = $temp_name;
                                        if (!move_uploaded_file($picture_new_temp_path, $imagespath.$picture_new_name))
                                            return lang('errCannotMoveUploadedImage');
                                        $picture_type = $picture_new_type;
                                        $picture_path = $picture_new_name;
                                    }
                                    if ($picture_id)
                                    {

                                        mysql_query("UPDATE files SET file_type = '$picture_new_type, path = '$picture_path', ".
                                                    "title = '$picture_title' WHERE id = $picture_id");
                                    }
                                    else
                                    {
                                        mysql_query("INSERT INTO files (file_type, path, title) VALUES ('$picture_type', '$picture_path', '$picture_title')");
                                        $picture_id = mysql_insert_id();
                                        $field->SetValue($picture_id);
                                    }
                                    $value = $field->GetValue();
                                    $updateSQLCondition .= "= ".$value['id'];
                                    break;
                                default:
                                    $updateSQLCondition .= "= ".$field->sqlValue;
                            }
                    }
                    else $updateSQLCondition .= "IS NULL";
                }
                else
                {
                    if (!$field->isAutoGenerated)
                    {
                        if (!$firstField)
                        {
                            $insertSQL .= ", ";
                            $insertSQLValues .= ", ";
                            $updateSQL .= ", ";
                        }
                        $insertSQL .= "`".$field->fieldName."`";
                        $updateSQL .= "`".$field->fieldName."` = ";
                        if ($field->value != "")
                        {
                            if ( ($field->NULLifZero) && (!$field->value) )
                            {
                                $insertSQLValues .= "NULL";
                                $updateSQL .= "NULL";
                            }
                            else
                                switch ($field->fieldType)
                                {
                                    case "picture":
                                        $value = $field->GetValue();
                                        $picture_id = $value['id'];
                                        $picture_path = $value['image'];
                                        $picture_type = $value['type'];
                                        $picture_title = $value['title'];
                                        $picture_new_name = $value['new_image'];
                                        $picture_new_path = $imagespath;
                                        $picture_new_temp_path = $value['new_image_temp'];
                                        $picture_new_type = $value['new_image_type'];
                                        if ($picture_new_temp_path)
                                        {
                                            if ($picture_path)
                                            {
                                                unlink($imagespath.$picture_path);
                                                if (file_exists($imagespath.$picture_path))
                                                    return lang('errCannotDeleteOldImage');
                                            }
                                            $temp_name = $picture_new_name;
                                            $i = 0;
                                            while (file_exists($imagespath.$temp_name))
                                                $temp_name = substr($picture_new_name, 0, strrpos($picture_new_name, '.') - 1).(++$i).
                                                             substr($picture_new_name, strpos($picture_new_name, '.'));
                                            $picture_new_name = $temp_name;
                                            if (!move_uploaded_file($picture_new_temp_path, $imagespath.$picture_new_name))
                                                return lang('errCannotMoveUploadedImage').'['.$picture_new_temp_path.'] ['.
                                                       $imagespath.$picture_new_name.']';
                                            $picture_type = $picture_new_type;
                                            $picture_path = $picture_new_name;
                                        }
                                        if ($picture_id)
                                        {
                                            mysql_query("UPDATE files SET file_type = '$picture_type', path = '$picture_path', ".
                                                        "title = '$picture_title' WHERE id = $picture_id");
                                        }
                                        else
                                        {
                                            mysql_query("INSERT INTO files (file_type, path, title) VALUES ('$picture_type', '$picture_path', '$picture_title')");
                                            $picture_id = mysql_insert_id();
                                            $field->SetValue($picture_id);
                                        }
                                        $value = $field->GetValue();
                                        $insertSQLValues .= $value['id'];
                                        $updateSQL .= $value['id'];
                                        break;
                                    default:
                                        $insertSQLValues .= $field->sqlValue;
                                        $updateSQL .= $field->sqlValue;
                                }
                        }
                        else
                        {
                            $insertSQLValues .= "NULL";
                            $updateSQL .= "NULL";
                        }
                        $firstField = false;
                    }
                }
            }

            $q = mysql_query("SELECT 1 FROM `".$this->tableName."`".$updateSQLCondition);
            if (mysql_num_rows($q))
            {
                $updateSQL .= $updateSQLCondition;
                /*if ($debug)*/ echo "<pre>".$updateSQL."</pre>";

                mysql_query($updateSQL);
                return mysql_error();
            }
            else
            {
                $insertSQL .= ")".$insertSQLValues.")";
                /*if ($debug)*/ echo "<pre>".$insertSQL."</pre>";
                mysql_query($insertSQL);
                if (!mysql_error())
                {
                    foreach ($this->fields as $field)
                    {
                        if ($field->isAutoGenerated)
                        {
                            $field->SetValue(mysql_insert_id());
                        }
                    }
                }
                return mysql_error();
            }
        }
        elseif ($action == 'do_delete')
        {
            $deleteSQL = "DELETE FROM `".$this->tableName."`";
            $deleteSQLCondition = "";
            foreach ($this->fields as $field)
            {
                if ($field->isPrimaryKey)
                {
                    if (!$deleteSQLCondition) $deleteSQLCondition = " WHERE ";
                                         else $deleteSQLCondition .= " AND ";
                    $deleteSQLCondition .= "`".$this->tableName."`.`".$field->fieldName."` ";
                    if ($field->GetValue() != "")
                    {
                        if ( ($field->NULLifZero) && (!$field->GetValue()) )
                        {
                            $deleteSQLCondition .= " IS NULL";
                        }
                        else
                            switch ($field->fieldType)
                            {
                                case "string":
                                case "text":
                                    $deleteSQLCondition .= "= '".$field->GetValue()."'";
                                    break;
                                case "date":
                                    $deleteSQLCondition .= "= '".mysql_date($field->GetValue())."'";
                                    break;
                                case "datetime":
                                    $deleteSQLCondition .=  "= '".mysql_datetime($field->GetValue())."'";
                                    break;
                                default:
                                    $deleteSQLCondition .= "= ".$field->GetValue();
                            }
                    }
                    else $deleteSQLCondition .= "IS NULL";
                }
            }

            $deleteSQL .= $deleteSQLCondition;
            mysql_query($deleteSQL);

            foreach ($this->fields as $field)
            {
                if ($field->detailTable)
                {
                    $field->detailTable->fields[$field->detailKeyField]->SetValue($field->GetValue());
                    $error = $field->detailTable->Process();
                    if ($error) return $error;
                }
            }

            return mysql_error();
        }
    }

    public function Verify()
    {
        $errorMessage = "";
        foreach ($this->fields as $field)
        {
            if ( (!$field->GetValue()) && (!$field->allowNULL) )
            {
                $errorMessage .= "<br>".lang('errValFor')." ".$field->caption;
            }
        }
        if ($errorMessage) $errorMessage .= "<br>";
        return $errorMessage;
    }

    public function ShowSimplePage()
    {
        $this->ShowPage(true);
    }

    public function ShowPage($simple = false)
    {
        global $page, $submit, $action, $id, $errorMessage;

        /*
        foreach ($this->fields as $field)
        {
            if ($field->childKeyField)
            {
                switch ($action)
                {
                    case "do_edit_".$field->childTable->tableName:
                        if ($submit == lang('btnCancel'))
                        {
                            $id = getuserdata($this->tableName."_id", 0);
                            $action = "edit";
                            break;
                        }
                        ${$this->tableName."_id"} = getuserdata($this->tableName."_id", 0);
                        $this->GetDatabaseValues(${$this->tableName."_id"});
                        $field->childTable->GetUserValues();
                        $errorMessage = $field->childTable->Verify();
                        if (!$errorMessage) $errorMessage = $field->childTable->Process();
                        if (!$errorMessage)
                        {
                            $id = getuserdata($this->tableName."_id", 0);
                            $action = "edit";
                            break;
                        }
                    case "edit_".$field->childTable->tableName:
                        ${$this->tableName."_id"} = getuserdata($this->tableName."_id", 0);
                        $this->GetDatabaseValues(${$this->tableName."_id"});
                        if ($action == "do_edit_".$field->childTable->tableName) { $field->childTable->GetUserValues(); }
                                                                            else { $field->childTable->GetDatabaseValues($id); }
                        if ($simple)
                        {
                            writesimplepagetitle();
                            writesimplepageheader();
                        }
                        else
                        {
                            writepagetitle();
                            writepageheader();
                        }
                        //if ($errorMessage) echo "<div class='error'>$errorMessage</div>";
                        $field->childTable->ShowEditForm(true, "_".$field->childTable->tableName);
                        if ($simple) writesimplepagefooter();
                                else writepagefooter();
                        exit;
                    case "do_delete_".$field->childTable->tableName:
                        if ($submit == lang('btnCancel'))
                        {
                            $id = getuserdata($this->tableName."_id", 0);
                            $action = "edit";
                            break;
                        }
                        ${$this->tableName."_id"} = getuserdata($this->tableName."_id", 0);
                        $this->GetDatabaseValues(${$this->tableName."_id"});
                        $field->childTable->GetUserValues();
                        $errorMessage = $field->childTable->Process();
                        if (!$errorMessage)
                        {
                            $id = getuserdata($this->tableName."_id", 0);
                            $action = "edit";
                            break;
                        }
                    case "delete_".$field->childTable->tableName:
                        ${$this->tableName."_id"} = getuserdata($this->tableName."_id", 0);
                        $this->GetDatabaseValues(${$this->tableName."_id"});
                        $field->childTable->GetDatabaseValues($id);
                        if ($simple)
                        {
                            writesimplepagetitle();
                            writesimplepageheader();
                        }
                        else
                        {
                            writepagetitle();
                            writepageheader();
                        }
                        //if ($errorMessage) echo "<div class='error'>$errorMessage</div>";
                        $field->childTable->ShowDeleteForm("_".$field->childTable->tableName);
                        if ($simple) writesimplepagefooter();
                                else writepagefooter();
                        exit;
                }
            }
        }

        switch ($action)
        {
            case "do_edit":
                if ($submit == lang('btnCancel')) break;
                $this->GetUserValues();
                $errorMessage = $this->Verify();
                if (!$errorMessage) $errorMessage = $this->Process();
                if (!$errorMessage) break;
            case "edit":
                if ($action == "do_edit") $this->GetUserValues();
                                     else $this->GetDatabaseValues($id);
                if ($simple)
                {
                    writesimplepagetitle();
                    writesimplepageheader();
                }
                else
                {
                    writepagetitle();
                    writepageheader();
                }
                //if ($errorMessage) echo "<div class='error'>$errorMessage</div>";
                $this->ShowEditForm();
                if ($simple) writesimplepagefooter();
                        else writepagefooter();
                exit;
            case "do_delete":
                if ($submit == lang('btnCancel')) break;
                $this->GetUserValues();
                $errorMessage = $this->Process();
                if (!$errorMessage) break;
            case "delete":
                $this->GetDatabaseValues($id);
                if ($simple)
                {
                    writesimplepagetitle();
                    writesimplepageheader();
                }
                else
                {
                    writepagetitle();
                    writepageheader();
                }
                //if ($errorMessage) echo "<div class='error'>$errorMessage</div>";
                $this->ShowDeleteForm();
                if ($simple) writesimplepagefooter();
                        else writepagefooter();
                exit;
        }

        if ($simple)
        {
            writesimplepagetitle();
            writesimplepageheader();
        }
        else
        {*/
            writepagetitle();
            writepageheader();
        //}
        echo "<h1 class='first'>{$this->name}</h1>";
        //if ($errorMessage) echo "<div class='error'>$errorMessage</div>";
        if (!$this->Active) $this->Open();
        $this->ShowList("", array(), $simple);
        /*if ($simple) writesimplepagefooter();
                else*/ writepagefooter();
    }

    public function GenerateXML($gridObj = "", $parentRowId = "")
    {
        global $page, $debug;

//if ($this->tableName == 'site_components') $debug = true;
        if ($debug)
        {
            echo '<condition><![CDATA[';
            echo "($parentRowId)";
        }
        if (!$parentRowId)
        {   // if no parent is transmitted, I search for columns that would need a parent
            // and set the parent id to 0
            foreach($this->fields as $field)
                if ($field->treeParentField)
                {
                    $this->sqlWhere .= ($this->sqlWhere?' AND ':'').
                        '(IFNULL(`'.$this->tableName.'`.`'.$field->fieldName.'`, 0) = 0)';
                }
        }
        else
        {   // otherwise, I get the rows I need (parentData = table__field__value
            $parentData = explode('__', $parentRowId);
            for ($i = 0; $i < count($parentData); $i += 3)
            {
                foreach($this->fields as $field)
                {
                    if ($field->treeParentField == $parentData[$i + 1])
                    {
                        $this->sqlWhere .= ($this->sqlWhere?' AND ':'').
                            '(IFNULL(`'.$parentData[$i].'`.`'.$field->fieldName.'`, 0) = '.
                            $parentData[$i + 2].')';
                        break;
                    }
                }
            }
        }
        if ($debug)
        {
            echo $this->GenerateSelectSQL();
            echo ']]></condition>';
            exit;
        }

        $this->Open();

        if ($this->isActive)
        {
            $parentNodeId = "";
            if ($this->recordCount)
                foreach ($this->fields as $field)
                {
                    if ($field->treeParentField)
                        $parentNodeId .= (($parentNodeId)?'__':'').
                        $this->tableName.'__'.$this->fields[$field->treeParentField]->fieldName.'__'.
                        ($field->value?$field->formValue:0);
                }
            else $parentNodeId = "";//$parentRowId;
            echo "\n<rows".($parentRowId?" parent=\"$parentRowId\"":'').">";//($parentNodeId?" parent=\"$parentNodeId\"":'').">";
            if ($debug) echo "\n<row id=\"debug\"><cell>"./*$this->openWhere.*/$this->GenerateSelectSQL()."</cell></row>";
            // Output body
            while (!$this->isEof)
            {
                $rowId = "";
                $numChildren = 0;
                foreach ($this->fields as $field)
                {
                    if ($field->isPrimaryKey)
                    {
                        $rowId .= (($rowId)?'__':'').$field->table->tableName.'__'.
                                  $field->fieldName.'__'.$field->formValue;
                    }
                    if ($field->treeParentField)
                        $numChildren = $this->dataRow[$field->fieldAlias.'__CHILDCOUNT__'];
                }
                echo "\n    <row".(($rowId)?" id=\"$rowId\"":"");
                if ($parentNodeId) echo ' xmlkids="'.($numChildren?1:0).'"';
                echo ">";
                $primaryKeys = ""; // string prin care se trimit parametri pt functia de editare
                $parentFields = "";
                foreach ($this->fields as $field)
                {
                    if ($field->visibleInList)
                    {
                        echo "\n        <cell><![CDATA[".$field->displayValue."]]></cell>";
                    }
                    if ($field->isPrimaryKey)
                    {
                        //$primaryKeys .= (($primaryKeys)?'&':'').$field->fieldAlias.'='.$field->formValue;
                        $primaryKeys .= (($primaryKeys)?' AND ':'')."`".$field->table->tableAlias."`.`".
                                        $field->fieldName.'` = '.$field->value;
                    }
                    if ($field->parentField != null)
                    {
                        $parentFields .= $field->parentField->table->tableName.'.'.
                                         $field->parentField->fieldName.'='.
                                         $field->parentField->value;
                    }
                }
                if ($this->allowEdit)
                    echo "\n        <cell><![CDATA[".lang('btnEdit')."^javascript:editDBItem(\"".
                         $this->internalName."\", \"".$primaryKeys."\", \"\", \"$gridObj\", \"{$this->sqlWhere}\")^_self]]></cell>";
                if ($this->allowDelete)
                    echo "\n        <cell><![CDATA[".lang('btnDelete')."^javascript:deleteDBItem(\"".
                         $this->internalName."\", \"".$primaryKeys."\", \"\", \"$gridObj\", \"{$this->sqlWhere}\")^_self]]></cell>";
                echo "\n    </row>";
                $this->FetchRow();
            }
            echo "\n</rows>";
        }
        else
        {
            echo "<div class='error'><b>Internal error</b>: Cannot open table!".$this->GenerateSelectSQL()."</div>";
        }
    }

    public function GenerateComboXML($keyField, $valueField, $selectedKeyValue = "")
    {
        global $page, $debug;

        $this->Open();

        if ($this->isActive)
        {
            echo "\n<complete>";
            // Get MAX id (usually the new added one)
            $maxq = mysql_query("SELECT MAX(id) AS new_id FROM ".$this->tableName);
            $row = mysql_fetch_assoc($maxq);
            $max = $row['new_id'];
            // Output body
            while (!$this->isEof)
            {
                echo "\n    <option value=\"".$this->fields[$keyField]->formValue."\"";
                if ($this->fields[$keyField]->formValue == $max) echo " selected=\"1\"";
                echo "><![CDATA[";
                if (strpos($valueField, ';') === false)
                {
                    $returnValue = $this->fields[$valueField]->displayValue;
                }
                else
                {
                    $chunks = explode(';', $valueField);
                    $returnValue = "";
                    $sourceValueFields = array();
                    $i = 0;
                    foreach ($chunks as $chunk)
                    {
                        if (substr($chunk, 0, 1) == '[')
                        {
                            $sourceValueFields[$i]['prefix'] = substr($chunk, 1, strpos($chunk, ']') - 1);
                            $chunk = substr($chunk, strpos($chunk, ']') + 1);
                        }
                        else $sourceValueFields[$i]['prefix'] = ($i)?' ':'';
                        if (strpos($chunk, '[') !== false)
                        {
                            $sourceValueFields[$i]['suffix'] = str_replace(']', '', substr($chunk, strpos($chunk, '[') + 1));
                            $chunk = substr($chunk, 0, strpos($chunk, '['));
                        }
                        else $sourceValueFields[$i]['suffix'] = '';
                        $sourceValueFields[$i++]['field'] = $chunk;
                    }
                    foreach ($sourceValueFields as $sourceValueField)
                    {
                        $returnValue .= $sourceValueField['prefix'].
                                        $this->fields[$sourceValueField['field']]->displayValue.
                                        $sourceValueField['suffix'];
                    }
                }
                echo $returnValue."]]></option>";
                $this->FetchRow();
            }
            echo "\n</complete>";
        }
        else
        {
            echo "<error>Internal error: Cannot open table!</error>";
        }
    }

    public function GetGridHeaders()
    {
        $result = "";
        foreach ($this->fields as $field)
            if ($field->visibleInList)
                $result .= (($result)?',':'').str_replace("'", "\\'", $field->caption);
        if ($this->allowEdit) $result .= ','.lang('btnEdit');
        if ($this->allowDelete) $result .= ','.lang('btnDelete');
        return $result;
    }

    public function GetGridWidths()
    {
        $result = "";
        foreach ($this->fields as $field)
            if ($field->visibleInList)
                $result .= (($result)?',':'').$field->gridWidth;
        if ($this->allowEdit) $result .= ',50';
        if ($this->allowDelete) $result .= ',50';
        return $result;
    }

    public function GetGridColumnTypes()
    {
        $result = "";
        $isTree = false;
        foreach ($this->fields as $field)
            if ($field->treeParentField) $isTree = true;
        $tree_shown = false;
        foreach ($this->fields as $field)
            if ($field->visibleInList)
                if (($isTree) && (!$tree_shown) )
                {
                    $result .= (($result)?',':'').'tree';
                    $tree_shown = true;
                }
                else
                    $result .= (($result)?',':'').((($field->gridType=='ed')&&(!$this->allowEdit))?'ro':$field->gridType);
        if ($this->allowEdit) $result .= ',link';
        if ($this->allowDelete) $result .= ',link';
        return $result;
    }

    public function GetGridColumnColors()
    {
        $result = "";
        foreach ($this->fields as $field)
            if ($field->visibleInList)
                $result .= (($result)?',':'').($field->gridColor?$field->gridColor:'');
        if ($this->allowEdit) $result .= ',';
        if ($this->allowDelete) $result .= ',';
        return $result;
    }

    public function GetGridAlign()
    {
        $result = "";
        foreach ($this->fields as $field)
            if ($field->visibleInList)
                $result .= (($result)?',':'').$field->gridAlign;
        if ($this->allowEdit) $result .= ',center';
        if ($this->allowDelete) $result .= ',center';
        return $result;
    }

    public function GetGridSorting()
    {
        $result = "";
        foreach ($this->fields as $field)
            if ($field->visibleInList)
                $result .= (($result)?',':'').'connector';
        if ($this->allowEdit) $result .= ',';
        if ($this->allowDelete) $result .= ',';
        return $result;
    }

    public function GetGridFilters()
    {
        $result = "";
        foreach ($this->fields as $field)
            if ($field->visibleInList)
                $result .= (($result)?',':'').'#connector_text_filter';
        if ($this->allowEdit) $result .= ',';
        if ($this->allowDelete) $result .= ',';
        return $result;
    }

    public function ShowOptionsPage($simple = false)
    {
        global $page, $submit, $action, $id, $errorMessage;
        writepagetitle();
        writepageheader();
        $this->ShowEditForm('netopt');
        writepagefooter();
    }

    public function GenerateConnectorXML()
    {
        $keyfields = "";
        $gridfields = "";
        foreach ($this->fields as $field)
        {
            if ($field->isPrimaryKey)
            {
                $keyfields .= (strlen($keyfields) ? ', ' : '').$field->fieldAlias;//.'('.$field->fieldAlias.')';
            }
            elseif ($field->visibleInList)
                $gridfields .= (strlen($gridfields) ? ', ' : '').$field->fieldAlias;//.'('.$field->fieldAlias.')';
        }
        $gridfields .= ', btnEdit, btnDelete';
        if ($this->isActive)
        {
            $this->dataConnection->dynamic_loading(50);
            //if ($this->dataConnection->is_select_mode())
                $this->dataConnection->render_sql(
                    'SELECT * FROM ('.$this->GenerateSelectSQL().") t \n", $keyfields, $gridfields);
                    //$this->GenerateSelectSQL(), $keyfields, $gridfields);
            /*else
                $this->dataConnection->render_table($this->tableName, $keyfields, $gridfields);*/
        }
    }
}

?>