<?php

require_once("TField.php");

class TDateTimeField extends TField
{
    public function SetValue($value)
    {
        if (strstr($value, '-'))
        {
            $this->value = mktime(substr($value, 11, 2), substr($value, 14, 2), substr($value, 17, 2),
                                  substr($value, 5, 2), substr($value, 8, 2), substr($value, 0, 4));
        }
        else
        {
            $this->value = mktime(substr($value, 11, 2), substr($value, 14, 2), substr($value, 17, 2),
                                  substr($value, 3, 2), substr($value, 0, 2), substr($value, 6, 4));
        }
        $this->displayValue = date("d.m.Y H:i:s", $this->GetValue());
    }

    public function GetValue()
    {
        return (($this->parentField)?$this->parentField->GetValue():(date('Y',$this->value) <= 1970)?0:$this->value);
    }

    protected function ShowFieldEditor($formFieldName)
    {
        $strValue = date('d.m.Y H:i:s', $this->GetValue());
        echo "\n    <div id='field_".$formFieldName."' class='DateTimeField'>";
        echo "\n    <label for='".$formFieldName."' id='lbl_".$formFieldName."'>".$this->caption.":</label>";
        echo "\n    <input type='text' style='width: 6em' name='".$formFieldName."' id='".$formFieldName."' value='".$strValue."' readonly>";
        echo "\n    <a href='javascript:NewCssCal(\"".$formFieldName."\", \"ddMMyyyy\", \"DropDown\", true, 24, true)'> ";
        echo "<img src='img/cal.gif' width='16' height='16' alt='".lang('alSelTime')."'></a></input>";
        echo "\n    </div>";
    }
}

?>