<?php

require_once("TField.php");

class TDateField extends TField
{
    function __construct()
    {
        $this->gridWidth = "*";
        $this->gridType = "dhxCalendar";
        $this->gridAlign = "left";
        $this->gridColor = "";
        $this->gridSort = "str";
        $this->internalValue = 0;
    }
    
    public function __get($property)
    {
        switch($property)
        {
            case "fieldAlias":
                if ($this->table)
                    if ($this->table->tableAlias)
                        return $this->table->tableAlias.'_'.$this->fieldName;
                    else
                        return $this->table->tableName.'_'.$this->fieldName;
                else
                    return FALSE;
                break;
            case "value":
                return $this->internalValue;
                break;
            case "sqlValue":
                if ($this->internalValue > 0)
                    return "'".date("Y-m-d", $this->internalValue)."'";
                else
                    return 'NULL';
                break;
            case "formValue":
                return date('d.m.Y', $this->internalValue);
                break;
            case "displayValue":
                if ($this->parentField)
                    return $this->parentField->displayValue;
                elseif ($this->sourceTable)
                {
                    return $this->ParseTableValues($this->sourceTable, $this->sourceValueField);
                }
                elseif ($this->detailTable)
                {
                    return $this->ParseTableValues($this->detailTable, $this->detailValueField);
                }
                else
                    return ($this->internalValue > 0)?date('d.m.Y', $this->internalValue):"&nbsp";
                break;
        }
    } 
    
    public function __set($property, $property_value)
    {
        switch($property)
        {
            case "value":
                if ($property_value)
                    //$this->internalValue = $property_value;
                    $this->internalValue = mktime(0, 0, 0, substr($property_value, 3, 2), substr($property_value, 0, 2), substr($property_value, 6, 4));
                else
                    $this->internalValue = 0;
                break;
            case "sqlValue":
                if ($property_value)
                    $this->internalValue = get_mysql_date($property_value);
                else
                    $this->internalValue = 0;
                break;
            case "formValue":
                $property_value = getuserdata($this->table->tableAlias.'_'.$this->fieldName);
                $this->internalValue = mktime(0, 0, 0, substr($property_value, 3, 2), substr($property_value, 0, 2), substr($property_value, 6, 4));
        }
    }  

    public function SetValue($value)
    {
        if (is_string($value))
        {
            if (strstr($value, '-'))
            {
                $this->value = mktime(0, 0, 0, substr($value, 5, 2), substr($value, 8, 2), substr($value, 0, 4));
            }
            else
            {
                $this->value = mktime(0, 0, 0, substr($value, 3, 2), substr($value, 0, 2), substr($value, 6, 4));
            }
        }
        else $this->value = $value;
        if ($this->GetValue()) $this->displayValue = date("d.m.Y", $this->GetValue());
                          else $this->displayValue = '';
    }

    public function GetValue()
    {
        return (($this->parentField)?$this->parentField->GetValue():(date('Y',$this->value) <= 1970)?0:$this->value);
    }

    public function GetDisplayValue()
    {
        if ($this->value) $strValue = date('d.m.Y', $this->value);
                     else $strValue = '&nbsp;';
        return (($this->parentField)?$this->parentField->GetDisplayValue():$strValue);
    }

    protected function ShowFieldEditor($formFieldName)
    {
        global $scriptroot;
        echo "\n    <div id='field_".$formFieldName."' class='DateField'>";
        echo "\n    <label for='".$formFieldName."' id='lbl_".$formFieldName."'>".$this->caption.":</label>";
        echo "\n    <input type='text' style='width: 7em' name='".$formFieldName."' id='".$formFieldName."' value='".$this->displayValue."' autocomplete='0'>";
        /*echo "\n    <a href='javascript:NewCssCal(\"".$formFieldName."\", \"ddMMyyyy\", \"DropDown\", false, 24, true)'> ";
        echo "<img src='img/cal.gif' width='16' height='16' alt='Select time'></a></input>";*/
        $calendar = 'cal_'.date('YmdHis').'_'.$formFieldName;
        echo "\n    <img src='{$scriptroot}/img/icon_minicalendar.gif' style='position: relative; left: -1px'
                    onclick='if ($calendar.isVisible()) $calendar.hide();} else $calendar.show();}'>";
        echo "\n    <script type='text/javascript'>
              \n        var $calendar = new dhtmlXCalendarObject('$formFieldName');
              \n        $calendar.setSkin('');
              \n        $calendar.setDateFormat('%d.%m.%Y');
              \n        $calendar.options.weekstart = 1;
              \n        $calendar.options.isYearEditable = true;
              \n        $calendar.options.isWinHeader = true;
              \n        $calendar.options.headerButtons = 'X';
              \n        $calendar.draw();
              \n    </script>";
        echo "\n    </div>";
    }
}

?>